/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.randomteleport;

import com.eternalcode.core.feature.randomteleport.RandomTeleportResolveWorldUtil;
import com.eternalcode.core.feature.randomteleport.RandomTeleportResult;
import com.eternalcode.core.feature.randomteleport.RandomTeleportSafeLocationService;
import com.eternalcode.core.feature.randomteleport.RandomTeleportService;
import com.eternalcode.core.feature.randomteleport.RandomTeleportSettings;
import com.eternalcode.core.feature.teleport.Teleport;
import com.eternalcode.core.feature.teleport.TeleportResult;
import com.eternalcode.core.feature.teleport.TeleportTaskService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.Position;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.PositionAdapter;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

@Service
class RandomTeleportTaskService {
    private final NoticeService noticeService;
    private final RandomTeleportSettings randomTeleportSettings;
    private final TeleportTaskService teleportTaskService;
    private final RandomTeleportSafeLocationService randomTeleportSafeLocationService;
    private final RandomTeleportService randomTeleportService;

    @Inject
    RandomTeleportTaskService(NoticeService noticeService, RandomTeleportSettings randomTeleportSettings, TeleportTaskService teleportTaskService, RandomTeleportSafeLocationService randomTeleportSafeLocationService, RandomTeleportService randomTeleportService) {
        this.noticeService = noticeService;
        this.randomTeleportSettings = randomTeleportSettings;
        this.teleportTaskService = teleportTaskService;
        this.randomTeleportSafeLocationService = randomTeleportSafeLocationService;
        this.randomTeleportService = randomTeleportService;
    }

    CompletableFuture<RandomTeleportResult> createTeleport(Player player) {
        World world = RandomTeleportResolveWorldUtil.resolveWorld(player, this.randomTeleportSettings);
        return this.randomTeleportSafeLocationService.getSafeRandomLocation(world, this.randomTeleportSettings.radius(), this.randomTeleportSettings.teleportAttempts()).thenCompose(location -> this.createTeleport(player, (Location)location));
    }

    private CompletableFuture<RandomTeleportResult> createTeleport(Player player, Location location) {
        if (player.hasPermission("eternalcore.rtp.bypass")) {
            return this.randomTeleportService.teleport(player);
        }
        if (this.teleportTaskService.isInTeleport(player.getUniqueId())) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.teleport().teleportTaskAlreadyExist())).player(player.getUniqueId())).send();
            return CompletableFuture.completedFuture(new RandomTeleportResult(false, player.getLocation()));
        }
        Location playerLocation = player.getLocation();
        Position playerPosition = PositionAdapter.convert((Location)playerLocation);
        Position destination = PositionAdapter.convert((Location)location);
        Duration time = this.randomTeleportSettings.delay();
        Teleport teleport = this.teleportTaskService.createTeleport(player.getUniqueId(), playerPosition, destination, time);
        return teleport.getResult().thenApply(result -> new RandomTeleportResult(result == TeleportResult.SUCCESS, location));
    }
}

