/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.msg;

import com.eternalcode.core.event.EventCaller;
import com.eternalcode.core.feature.ignore.IgnoreService;
import com.eternalcode.core.feature.msg.Message;
import com.eternalcode.core.feature.msg.MsgEvent;
import com.eternalcode.core.feature.msg.MsgPresenter;
import com.eternalcode.core.feature.msg.MsgService;
import com.eternalcode.core.feature.msg.toggle.MsgState;
import com.eternalcode.core.feature.msg.toggle.MsgToggleService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.user.User;
import com.eternalcode.core.user.UserManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.entity.Player;

@Service
class MsgServiceImpl
implements MsgService {
    private final NoticeService noticeService;
    private final IgnoreService ignoreService;
    private final UserManager userManager;
    private final MsgPresenter presenter;
    private final EventCaller eventCaller;
    private final MsgToggleService msgToggleService;
    private final Server server;
    private final Cache<UUID, UUID> replies = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofHours(1L)).build();
    private final Set<UUID> socialSpy = new HashSet<UUID>();

    @Inject
    MsgServiceImpl(NoticeService noticeService, IgnoreService ignoreService, UserManager userManager, EventCaller eventCaller, MsgToggleService msgToggleService, Server server) {
        this.noticeService = noticeService;
        this.ignoreService = ignoreService;
        this.userManager = userManager;
        this.eventCaller = eventCaller;
        this.msgToggleService = msgToggleService;
        this.presenter = new MsgPresenter(noticeService);
        this.server = server;
    }

    @Override
    public void reply(Player sender, String message) {
        UUID uuid = (UUID)this.replies.getIfPresent((Object)sender.getUniqueId());
        if (uuid == null) {
            this.noticeService.player(sender.getUniqueId(), translation -> translation.msg().noReply(), new Formatter[0]);
            return;
        }
        Player target = this.server.getPlayer(uuid);
        if (target == null) {
            this.noticeService.player(sender.getUniqueId(), translation -> translation.argument().offlinePlayer(), new Formatter[0]);
            return;
        }
        this.sendMessage(sender, target, message);
    }

    @Override
    public void sendMessage(Player sender, Player target, String message) {
        UUID uniqueId = target.getUniqueId();
        this.msgToggleService.getState(uniqueId).thenAccept(msgState -> {
            if (msgState == MsgState.DISABLED) {
                this.noticeService.player(sender.getUniqueId(), translation -> translation.msg().receiverDisabledMessages(), new Formatter[0]);
                return;
            }
            this.ignoreService.isIgnored(uniqueId, sender.getUniqueId()).thenAccept(isIgnored -> {
                if (!isIgnored.booleanValue()) {
                    this.replies.put((Object)uniqueId, (Object)sender.getUniqueId());
                    this.replies.put((Object)sender.getUniqueId(), (Object)uniqueId);
                }
                MsgEvent event = new MsgEvent(sender.getUniqueId(), uniqueId, message);
                this.eventCaller.callEvent(event);
                this.presenter.onMessage(new Message(this.toUser(sender), this.toUser(target), event.getContent(), (Collection<UUID>)this.socialSpy, (boolean)isIgnored));
            });
        });
    }

    @Override
    public void enableSpy(UUID player) {
        this.socialSpy.add(player);
    }

    @Override
    public void disableSpy(UUID player) {
        this.socialSpy.remove(player);
    }

    @Override
    public boolean isSpy(UUID player) {
        return this.socialSpy.contains(player);
    }

    private User toUser(Player target) {
        return this.userManager.getUser(target.getUniqueId()).orElseThrow(() -> new IllegalStateException("User not found for player " + target.getName()));
    }
}

