/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.gamemode;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Context;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invalidusage.InvalidUsageException;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.litecommand.configurator.config.CommandConfiguration;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(name="gamemode", aliases={"gm"})
class GameModeCommand {
    private final CommandConfiguration commandConfiguration;
    private final NoticeService noticeService;

    @Inject
    GameModeCommand(CommandConfiguration commandConfiguration, NoticeService noticeService) {
        this.commandConfiguration = commandConfiguration;
        this.noticeService = noticeService;
    }

    @Execute
    @Permission(value={"eternalcore.gamemode"})
    void executeAlias(@Context Invocation<CommandSender> invocation, @Sender Player player) {
        GameMode gameMode = this.commandConfiguration.getGameMode(invocation.label());
        if (gameMode == null) {
            throw new InvalidUsageException((Object)InvalidUsage.Cause.INVALID_ARGUMENT);
        }
        this.execute(player, gameMode);
    }

    @Execute
    @Permission(value={"eternalcore.gamemode"})
    @DescriptionDocs(description={"Sets your gamemode"}, arguments={"<gamemode>"})
    void execute(@Sender Player sender, @Arg GameMode gameMode) {
        sender.setGameMode(gameMode);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.gamemode().gamemodeSet())).placeholder("{GAMEMODE}", gameMode.name())).player(sender.getUniqueId())).send();
    }

    @Execute
    @Permission(value={"eternalcore.gamemode.other"})
    @DescriptionDocs(description={"Sets gamemode of another player"}, arguments={"<gamemode> <player>"})
    void execute(@Sender Viewer sender, @Arg GameMode gameMode, @Arg Player player) {
        player.setGameMode(gameMode);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.gamemode().gamemodeSet())).placeholder("{GAMEMODE}", gameMode.name())).player(player.getUniqueId())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.gamemode().gamemodeSetToTarget())).placeholder("{GAMEMODE}", gameMode.name())).placeholder("{PLAYER}", player.getName())).viewer(sender)).send();
    }
}

