/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.fun.elderguardian;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.compatibility.Compatibility;
import com.eternalcode.core.compatibility.Version;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.flag.Flag;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.paper.PaperOverlay;
import org.bukkit.entity.Player;

@Command(name="elderguardian", aliases={"elder-guardian"})
@Permission(value={"eternalcore.troll.elderguardian"})
@Compatibility(from=@Version(minor=19, patch=2))
public class ElderGuardianCommand {
    private final NoticeService noticeService;

    @Inject
    public ElderGuardianCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Show an elder guardian to a player"}, arguments={"<player>", "[-s]"})
    void execute(@Sender Player sender, @Arg Player target, @Flag(value={"-s"}) boolean silent) {
        if (silent) {
            PaperOverlay.ELDER_GUARDIAN_SILENT.show(target);
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.elderGuardian().elderGuardianShownSilently())).player(sender.getUniqueId())).placeholder("{PLAYER}", target.getName())).send();
            return;
        }
        PaperOverlay.ELDER_GUARDIAN.show(target);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.elderGuardian().elderGuardianShown())).player(sender.getUniqueId())).placeholder("{PLAYER}", target.getName())).send();
    }
}

