/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.fly;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.entity.Player;

@Command(name="fly")
class FlyCommand {
    private final NoticeService noticeService;

    @Inject
    FlyCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    @Permission(value={"eternalcore.fly"})
    @DescriptionDocs(description={"Toggle fly mode"})
    void execute(@Sender Player player) {
        player.setAllowFlight(!player.getAllowFlight());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> player.getAllowFlight() ? translation.fly().flyEnabled() : translation.fly().flyDisabled())).placeholder("{STATE}", translation -> player.getAllowFlight() ? translation.format().enable() : translation.format().disable())).player(player.getUniqueId())).send();
    }

    @Execute
    @Permission(value={"eternalcore.fly.other"})
    @DescriptionDocs(description={"Toggle fly mode for specified player"}, arguments={"<player>"})
    void execute(@Sender Viewer viewer, @Arg Player target) {
        target.setAllowFlight(!target.getAllowFlight());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> target.getAllowFlight() ? translation.fly().flyEnabled() : translation.fly().flyDisabled())).placeholder("{STATE}", translation -> target.getAllowFlight() ? translation.format().enable() : translation.format().disable())).player(target.getUniqueId())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> target.getAllowFlight() ? translation.fly().flyEnabledForTarget() : translation.fly().flyDisabledForTarget())).placeholder("{PLAYER}", target.getName())).placeholder("{STATE}", translation -> target.getAllowFlight() ? translation.format().enable() : translation.format().disable())).viewer(viewer)).send();
    }
}

