/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.automessage;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.automessage.AutoMessageService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.NoticeService;
import org.bukkit.entity.Player;

@Command(name="automessage", aliases={"automsg"})
@Permission(value={"eternalcore.automessage"})
class AutoMessageCommand {
    private final AutoMessageService autoMessageService;
    private final NoticeService noticeService;

    @Inject
    AutoMessageCommand(AutoMessageService autoMessageService, NoticeService noticeService) {
        this.autoMessageService = autoMessageService;
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Toggles the display of automatic messages."})
    void execute(@Sender Player player) {
        this.autoMessageService.switchReceiving(player.getUniqueId()).thenAccept(receiving -> {
            if (receiving.booleanValue()) {
                this.noticeService.player(player.getUniqueId(), messages -> messages.autoMessage().enabled(), new Formatter[0]);
                return;
            }
            this.noticeService.player(player.getUniqueId(), messages -> messages.autoMessage().disabled(), new Formatter[0]);
        });
    }
}

