/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.database;

import com.eternalcode.core.database.DatabaseDriverType;
import com.eternalcode.core.database.DatabaseSettings;
import com.eternalcode.core.libs.eu.okaeri.configs.OkaeriConfig;
import com.eternalcode.core.libs.eu.okaeri.configs.annotation.Comment;
import lombok.Generated;

public class DatabaseConfig
extends OkaeriConfig
implements DatabaseSettings {
    @Comment(value={"Type of the database driver (e.g., SQLITE, H2, MYSQL, MARIADB, POSTGRESQL).", "Determines the database type to be used."})
    public DatabaseDriverType databaseType = DatabaseDriverType.SQLITE;
    @Comment(value={"Hostname of the database server.", "For local databases, this is usually 'localhost'."})
    public String hostname = "localhost";
    @Comment(value={"Port number of the database server. Common ports:", " - MySQL: 3306", " - PostgreSQL: 5432", " - H2: Not applicable (file-based)", " - SQLite: Not applicable (file-based)"})
    public int port = 3306;
    @Comment(value={"Name of the database to connect to. This is the name of the specific database instance."})
    public String database = "eternalcore";
    @Comment(value={"Username for the database connection. This is the user account used to authenticate with the database."})
    public String username = "root";
    @Comment(value={"Password for the database connection. This is the password for the specified user account."})
    public String password = "password";
    @Comment(value={"Enable SSL for the database connection. Set to true to use SSL/TLS for secure connections."})
    public boolean ssl = false;
    @Comment(value={"Connection pool size. This determines the maximum number of connections in the pool."})
    public int poolSize = 16;
    @Comment(value={"Connection timeout in milliseconds. This is the maximum time to wait for a connection from the pool."})
    public int timeout = 30000;

    @Override
    @Generated
    public DatabaseDriverType databaseType() {
        return this.databaseType;
    }

    @Override
    @Generated
    public String hostname() {
        return this.hostname;
    }

    @Override
    @Generated
    public int port() {
        return this.port;
    }

    @Override
    @Generated
    public String database() {
        return this.database;
    }

    @Override
    @Generated
    public String username() {
        return this.username;
    }

    @Override
    @Generated
    public String password() {
        return this.password;
    }

    @Override
    @Generated
    public boolean ssl() {
        return this.ssl;
    }

    @Override
    @Generated
    public int poolSize() {
        return this.poolSize;
    }

    @Override
    @Generated
    public int timeout() {
        return this.timeout;
    }
}

