/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.notice;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.com.eternalcode.commons.scheduler.Scheduler;
import com.eternalcode.core.libs.com.eternalcode.multification.Multification;
import com.eternalcode.core.libs.com.eternalcode.multification.adventure.AudienceConverter;
import com.eternalcode.core.libs.com.eternalcode.multification.executor.AsyncExecutor;
import com.eternalcode.core.libs.com.eternalcode.multification.notice.resolver.NoticeResolverRegistry;
import com.eternalcode.core.libs.com.eternalcode.multification.platform.PlatformBroadcaster;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Replacer;
import com.eternalcode.core.libs.com.eternalcode.multification.translation.TranslationProvider;
import com.eternalcode.core.libs.com.eternalcode.multification.viewer.ViewerProvider;
import com.eternalcode.core.libs.net.kyori.adventure.platform.AudienceProvider;
import com.eternalcode.core.libs.net.kyori.adventure.text.Component;
import com.eternalcode.core.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.eternalcode.core.libs.net.kyori.adventure.text.serializer.ComponentSerializer;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.placeholder.PlaceholderRegistry;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import com.eternalcode.core.user.UserManager;
import com.eternalcode.core.viewer.BukkitViewerProvider;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;

@Service
public class NoticeService
extends Multification<Viewer, Translation> {
    private final UserManager userManager;
    private final Scheduler scheduler;
    private final Server server;
    private final AudienceProvider audienceProvider;
    private final TranslationManager translationManager;
    private final PlaceholderRegistry registry;
    private final MiniMessage miniMessage;
    private final NoticeResolverRegistry noticeRegistry;

    @Inject
    public NoticeService(UserManager userManager, Scheduler scheduler, Server server, AudienceProvider audienceProvider, TranslationManager translationManager, PlaceholderRegistry registry, MiniMessage miniMessage, NoticeResolverRegistry noticeRegistry) {
        this.userManager = userManager;
        this.scheduler = scheduler;
        this.server = server;
        this.audienceProvider = audienceProvider;
        this.translationManager = translationManager;
        this.registry = registry;
        this.miniMessage = miniMessage;
        this.noticeRegistry = noticeRegistry;
    }

    @NotNull
    public ViewerProvider<Viewer> viewerProvider() {
        return new BukkitViewerProvider(this.userManager, this.server);
    }

    @NotNull
    public TranslationProvider<Translation> translationProvider() {
        return this.translationManager;
    }

    @NotNull
    public AudienceConverter<Viewer> audienceConverter() {
        return viewer -> {
            if (viewer.isConsole()) {
                return this.audienceProvider.console();
            }
            return this.audienceProvider.player(viewer.getUniqueId());
        };
    }

    @NotNull
    public AsyncExecutor asyncExecutor() {
        return arg_0 -> ((Scheduler)this.scheduler).runAsync(arg_0);
    }

    @NotNull
    public Replacer<Viewer> globalReplacer() {
        return (viewer, text) -> this.registry.format(text, (Viewer)viewer);
    }

    public NoticeResolverRegistry getNoticeRegistry() {
        return this.noticeRegistry;
    }

    public PlatformBroadcaster platformBroadcaster() {
        return PlatformBroadcaster.create(this.serializer(), (NoticeResolverRegistry)this.noticeRegistry);
    }

    @NotNull
    protected ComponentSerializer<Component, Component, String> serializer() {
        return this.miniMessage;
    }

    public EternalCoreBroadcast<Viewer, Translation, ?> create() {
        return new EternalCoreBroadcast(this.asyncExecutor(), this.translationProvider(), this.viewerProvider(), this.platformBroadcaster(), this.localeProvider(), this.audienceConverter(), this.globalReplacer(), this.noticeRegistry);
    }
}

