/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.litecommand.contextual;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteContextual;
import com.eternalcode.core.libs.com.eternalcode.multification.notice.Notice;
import com.eternalcode.core.libs.dev.rollczi.litecommands.context.ContextProvider;
import com.eternalcode.core.libs.dev.rollczi.litecommands.context.ContextResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@LiteContextual(value=Player.class)
class PlayerContextual
implements ContextProvider<CommandSender, Player> {
    private final TranslationManager translationManager;

    @Inject
    PlayerContextual(TranslationManager translationManager) {
        this.translationManager = translationManager;
    }

    public ContextResult<Player> provide(Invocation<CommandSender> invocation) {
        Object object = invocation.sender();
        if (object instanceof Player) {
            Player player = (Player)object;
            return ContextResult.ok(() -> player);
        }
        Translation translation = this.translationManager.getMessages();
        Notice onlyPlayer = translation.argument().onlyPlayer();
        return ContextResult.error((Object)onlyPlayer);
    }
}

