/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.litecommand.argument;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.litecommand.argument.AbstractViewerArgument;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import java.util.List;
import org.bukkit.command.CommandSender;

@LiteArgument(type=int.class, name="amount")
public class StackAmountArgument
extends AbstractViewerArgument<Integer> {
    private static final List<Integer> suggestions = List.of(Integer.valueOf(1), Integer.valueOf(8), Integer.valueOf(16), Integer.valueOf(32), Integer.valueOf(64));
    public static final String KEY = "amount";

    @Inject
    public StackAmountArgument(TranslationManager translationManager) {
        super(translationManager);
    }

    @Override
    public ParseResult<Integer> parse(Invocation<CommandSender> invocation, String argument, Translation translation) {
        try {
            int value = Integer.parseInt(argument);
            if (value <= 0) {
                return ParseResult.failure((Object)translation.argument().numberBiggerThanZero());
            }
            return ParseResult.success((Object)value);
        }
        catch (NumberFormatException exception) {
            return ParseResult.failure((Object)translation.argument().stackNumberIncorrect());
        }
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<Integer> argument, SuggestionContext context) {
        return (SuggestionResult)suggestions.stream().map(String::valueOf).collect(SuggestionResult.collector());
    }
}

