/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.teleportrequest.self;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.event.EventCaller;
import com.eternalcode.core.feature.ignore.IgnoreService;
import com.eternalcode.core.feature.teleportrequest.PreTeleportRequestEvent;
import com.eternalcode.core.feature.teleportrequest.TeleportRequestEvent;
import com.eternalcode.core.feature.teleportrequest.self.TeleportHereRequestService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;

@Command(name="tpahere")
@Permission(value={"eternalcore.tpahere"})
class TpaHereCommand {
    private final TeleportHereRequestService requestService;
    private final IgnoreService ignoreService;
    private final NoticeService noticeService;
    private final EventCaller eventCaller;

    @Inject
    TpaHereCommand(TeleportHereRequestService requestService, IgnoreService ignoreService, NoticeService noticeService, EventCaller eventCaller) {
        this.requestService = requestService;
        this.ignoreService = ignoreService;
        this.noticeService = noticeService;
        this.eventCaller = eventCaller;
    }

    @Execute
    @DescriptionDocs(description={"Send teleport request to player to teleport to you"}, arguments={"<player>"})
    void execute(@Sender Player sender, @Arg Player target) {
        if (sender.equals((Object)target)) {
            this.noticeService.player(sender.getUniqueId(), translation -> translation.tpa().tpaSelfMessage(), new Formatter[0]);
            return;
        }
        if (this.requestService.hasRequest(sender.getUniqueId(), target.getUniqueId())) {
            this.noticeService.player(sender.getUniqueId(), translation -> translation.tpa().tpaAlreadySentMessage(), new Formatter[0]);
            return;
        }
        PreTeleportRequestEvent preEvent = this.eventCaller.callEvent(new PreTeleportRequestEvent(sender, target));
        if (preEvent.isCancelled()) {
            return;
        }
        this.isIgnoring(target, sender).thenAccept(isIgnoring -> {
            if (isIgnoring.booleanValue()) {
                ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(sender.getUniqueId())).notice(translation -> translation.tpa().tpaTargetIgnoresYou())).placeholder("{PLAYER}", target.getName())).send();
                return;
            }
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(sender.getUniqueId())).notice(translation -> translation.tpa().tpaHereSent())).placeholder("{PLAYER}", target.getName())).send();
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(target.getUniqueId())).notice(translation -> translation.tpa().tpaHereReceived())).placeholder("{PLAYER}", sender.getName())).send();
            this.requestService.createRequest(sender.getUniqueId(), target.getUniqueId());
            this.eventCaller.callEvent(new TeleportRequestEvent(sender, target));
        });
    }

    @Execute(name="-all", aliases={"*"})
    @Permission(value={"eternalcore.tpahere.all"})
    @DescriptionDocs(description={"Send teleport request to all online players to teleport to you"})
    void executeAll(@Sender Player sender) {
        for (Player target : sender.getServer().getOnlinePlayers()) {
            PreTeleportRequestEvent preEvent;
            if (target.getUniqueId().equals(sender.getUniqueId()) || this.requestService.hasRequest(sender.getUniqueId(), target.getUniqueId()) || (preEvent = this.eventCaller.callEvent(new PreTeleportRequestEvent(sender, target))).isCancelled()) continue;
            this.isIgnoring(target, sender).thenAccept(isIgnoring -> {
                if (isIgnoring.booleanValue()) {
                    return;
                }
                ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(target.getUniqueId())).notice(translation -> translation.tpa().tpaHereReceived())).placeholder("{PLAYER}", sender.getName())).send();
                this.requestService.createRequest(sender.getUniqueId(), target.getUniqueId());
                this.eventCaller.callEvent(new TeleportRequestEvent(sender, target));
            });
        }
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(sender.getUniqueId())).notice(translation -> translation.tpa().tpaHereSentToAll())).send();
    }

    private CompletableFuture<Boolean> isIgnoring(Player target, Player sender) {
        return this.ignoreService.isIgnored(target.getUniqueId(), sender.getUniqueId());
    }
}

