/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.teleportrequest.self;

import com.eternalcode.core.feature.teleportrequest.TeleportRequestSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

@Service
class TeleportHereRequestService {
    private final Cache<UUID, UUID> requests;

    @Inject
    TeleportHereRequestService(TeleportRequestSettings settings) {
        this.requests = CacheBuilder.newBuilder().expireAfterWrite(settings.tpaRequestExpire()).build();
    }

    void createRequest(UUID requester, UUID target) {
        this.requests.put((Object)requester, (Object)target);
    }

    void removeRequest(UUID requester) {
        this.requests.asMap().remove(requester);
    }

    boolean hasRequest(UUID requester, UUID target) {
        ConcurrentMap map = this.requests.asMap();
        for (Map.Entry entry : map.entrySet()) {
            if (!((UUID)entry.getKey()).equals(requester) || !((UUID)entry.getValue()).equals(target)) continue;
            return true;
        }
        return false;
    }

    List<UUID> findRequests(UUID target) {
        ConcurrentMap map = this.requests.asMap();
        ArrayList<UUID> requesters = new ArrayList<UUID>();
        for (Map.Entry entry : map.entrySet()) {
            if (!((UUID)entry.getValue()).equals(target)) continue;
            requesters.add((UUID)entry.getKey());
        }
        return requesters;
    }
}

