/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.msg;

import com.eternalcode.core.feature.msg.Message;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.placeholder.Placeholders;
import java.util.UUID;

class MsgPresenter {
    private static final Placeholders<Message> PLACEHOLDERS = Placeholders.builder().with("{MESSAGE}", message -> MiniMessage.miniMessage().escapeTags(message.message())).with("{TARGET}", message -> message.target().getName()).with("{SENDER}", message -> message.sender().getName()).build();
    private final NoticeService notice;

    public MsgPresenter(NoticeService noticeService) {
        this.notice = noticeService;
    }

    void onMessage(Message event) {
        Formatter formatter = PLACEHOLDERS.toFormatter(event);
        UUID sender = event.sender().getUniqueId();
        UUID target = event.target().getUniqueId();
        if (!event.ignored()) {
            this.notice.player(target, translation -> translation.msg().msgTargetToYou(), new Formatter[]{formatter});
        }
        this.notice.player(sender, translation -> translation.msg().msgYouToTarget(), new Formatter[]{formatter});
        this.notice.players(event.spies(), translation -> translation.msg().socialSpyMessage(), new Formatter[]{formatter});
    }
}

