/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.warp;

import com.eternalcode.core.feature.warp.Warp;
import com.eternalcode.core.feature.warp.WarpImpl;
import com.eternalcode.core.feature.warp.WarpService;
import com.eternalcode.core.feature.warp.repository.WarpRepository;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.PositionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Location;

@Service
class WarpServiceImpl
implements WarpService {
    private final Map<String, Warp> warps = new ConcurrentHashMap<String, Warp>();
    private final WarpRepository warpRepository;

    @Inject
    WarpServiceImpl(WarpRepository warpRepository) {
        this.warpRepository = warpRepository;
        this.loadWarps();
    }

    private void loadWarps() {
        this.warpRepository.getWarps().thenAcceptAsync(warps -> warps.forEach(warp -> this.warps.put(warp.getName(), (Warp)warp)));
    }

    @Override
    public Warp createWarp(String name, Location location) {
        WarpImpl warp = new WarpImpl(name, PositionAdapter.convert((Location)location), new ArrayList<String>());
        this.warps.put(name, warp);
        this.warpRepository.saveWarp(warp);
        return warp;
    }

    @Override
    public void removeWarp(String warpName) {
        Warp removed = this.warps.remove(warpName);
        if (removed != null) {
            this.warpRepository.removeWarp(removed.getName());
        }
    }

    @Override
    public Warp addPermissions(String warpName, String ... permissions) {
        Warp warp = this.modifyPermissions(warpName, perms -> perms.addAll(List.of(permissions)));
        this.warpRepository.saveWarp(warp);
        return warp;
    }

    @Override
    public Warp removePermissions(String warpName, String ... permissions) {
        Warp warp = this.modifyPermissions(warpName, perms -> perms.removeAll(List.of(permissions)));
        this.warpRepository.saveWarp(warp);
        return warp;
    }

    private Warp modifyPermissions(String warpName, Consumer<List<String>> modifier) {
        Warp warp = this.warps.get(warpName);
        if (warp == null) {
            throw new IllegalArgumentException("Warp " + warpName + " does not exist");
        }
        ArrayList<String> updatedPermissions = new ArrayList<String>(warp.getPermissions());
        modifier.accept(updatedPermissions);
        WarpImpl updatedWarp = new WarpImpl(warp.getName(), PositionAdapter.convert((Location)warp.getLocation()), updatedPermissions);
        this.warps.put(warpName, updatedWarp);
        return updatedWarp;
    }

    @Override
    public boolean exists(String warp) {
        return this.warps.containsKey(warp);
    }

    @Override
    public Optional<Warp> findWarp(String warp) {
        return Optional.ofNullable(this.warps.get(warp));
    }

    @Override
    public Collection<Warp> getWarps() {
        return Collections.unmodifiableCollection(this.warps.values());
    }
}

