/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.vanish;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@Service
class VanishInvisibleService {
    private final Set<UUID> vanishedPlayers = ConcurrentHashMap.newKeySet();
    private final Set<String> vanishedPlayerNames = ConcurrentHashMap.newKeySet();
    private final Plugin plugin;
    private final Server server;

    @Inject
    VanishInvisibleService(Plugin plugin) {
        this.plugin = plugin;
        this.server = plugin.getServer();
    }

    void hidePlayer(Player player) {
        for (Player online : this.server.getOnlinePlayers()) {
            if (online.hasPermission("eternalcore.vanish.see") || online.equals((Object)player)) continue;
            online.hidePlayer(this.plugin, player);
        }
        this.vanishedPlayers.add(player.getUniqueId());
        this.vanishedPlayerNames.add(player.getName());
    }

    void showPlayer(Player player) {
        for (Player online : this.server.getOnlinePlayers()) {
            if (online.equals((Object)player)) continue;
            online.showPlayer(this.plugin, player);
        }
        this.vanishedPlayers.remove(player.getUniqueId());
        this.vanishedPlayerNames.remove(player.getName());
    }

    void hideVanishedPlayersFrom(Player player) {
        for (UUID uuid : this.vanishedPlayers) {
            Player vanishedPlayer = this.server.getPlayer(uuid);
            if (vanishedPlayer == null || vanishedPlayer.equals((Object)player)) continue;
            player.hidePlayer(this.plugin, vanishedPlayer);
        }
    }

    Set<UUID> getVanishedPlayers() {
        return Collections.unmodifiableSet(this.vanishedPlayers);
    }

    Set<String> getVanishedPlayerNames() {
        return Collections.unmodifiableSet(this.vanishedPlayerNames);
    }
}

