/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.vanish;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.vanish.VanishService;
import com.eternalcode.core.feature.vanish.messages.VanishMessages;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.multification.notice.provider.NoticeProvider;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import org.bukkit.entity.Player;

@Command(name="vanish", aliases={"v"})
@Permission(value={"eternalcore.vanish"})
class VanishCommand {
    private final NoticeService noticeService;
    private final VanishService vanishService;

    @Inject
    public VanishCommand(NoticeService noticeService, VanishService vanishService) {
        this.noticeService = noticeService;
        this.vanishService = vanishService;
    }

    @Execute
    @DescriptionDocs(description={"Toggle your vanish state"})
    void vanishSelf(@Sender Player player) {
        boolean vanished = this.vanishService.toggleVanish(player);
        this.sendMessage(player, player, (NoticeProvider<VanishMessages>)(vanished ? VanishMessages::vanishEnabled : VanishMessages::vanishDisabled));
    }

    @Execute
    @Permission(value={"eternalcore.vanish.other"})
    @DescriptionDocs(description={"Toggle vanish state for another player"})
    void vanishOther(@Sender Player player, @Arg Player target) {
        if (player.equals((Object)target)) {
            this.vanishSelf(player);
            return;
        }
        boolean vanished = this.vanishService.toggleVanish(target);
        this.sendMessage(player, target, (NoticeProvider<VanishMessages>)(vanished ? VanishMessages::vanishEnabledForOther : VanishMessages::vanishDisabledForOther));
        this.sendMessage(target, player, (NoticeProvider<VanishMessages>)(vanished ? VanishMessages::vanishEnabledByStaff : VanishMessages::vanishDisabledByStaff));
    }

    private void sendMessage(Player sender, Player target, NoticeProvider<VanishMessages> message) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(sender.getUniqueId())).placeholder("{PLAYER}", target.getName())).notice(messages -> message.extract((Object)messages.vanish()))).send();
    }
}

