/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.teleportrequest;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.teleport.TeleportTaskService;
import com.eternalcode.core.feature.teleportrequest.TeleportRequestService;
import com.eternalcode.core.feature.teleportrequest.TeleportRequestSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.PositionAdapter;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

@Command(name="tpaaccept", aliases={"tpaccept"})
@Permission(value={"eternalcore.tpaccept"})
class TpaAcceptCommand {
    private final TeleportRequestService requestService;
    private final TeleportTaskService teleportTaskService;
    private final NoticeService noticeService;
    private final TeleportRequestSettings settings;
    private final Server server;

    @Inject
    TpaAcceptCommand(TeleportRequestService requestService, TeleportTaskService teleportTaskService, NoticeService noticeService, TeleportRequestSettings settings, Server server) {
        this.requestService = requestService;
        this.teleportTaskService = teleportTaskService;
        this.noticeService = noticeService;
        this.settings = settings;
        this.server = server;
    }

    @Execute
    @DescriptionDocs(description={"Accept teleport request"}, arguments={"<player>"})
    void executeTarget(@Sender Player player, @Arg(value="requester") Player target) {
        this.teleportTaskService.createTeleport(target.getUniqueId(), PositionAdapter.convert((Location)target.getLocation()), PositionAdapter.convert((Location)player.getLocation()), this.settings.tpaTimer());
        this.requestService.removeRequest(target.getUniqueId());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.tpa().tpaAcceptMessage())).placeholder("{PLAYER}", target.getName())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(target.getUniqueId())).notice(translation -> translation.tpa().tpaAcceptReceivedMessage())).placeholder("{PLAYER}", player.getName())).send();
    }

    @Execute(name="-all", aliases={"*"})
    @DescriptionDocs(description={"Accept all teleport requests"})
    void executeAll(@Sender Player player) {
        List<UUID> requests = this.requestService.findRequests(player.getUniqueId());
        if (requests.isEmpty()) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.tpa().tpaAcceptNoRequestMessage(), new Formatter[0]);
            return;
        }
        for (UUID uniqueId : requests) {
            Player requester = this.server.getPlayer(uniqueId);
            this.requestService.removeRequest(uniqueId);
            if (requester == null) continue;
            this.teleportTaskService.createTeleport(requester.getUniqueId(), PositionAdapter.convert((Location)requester.getLocation()), PositionAdapter.convert((Location)player.getLocation()), this.settings.tpaTimer());
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(uniqueId)).notice(translation -> translation.tpa().tpaAcceptReceivedMessage())).placeholder("{PLAYER}", player.getName())).send();
        }
        this.noticeService.player(player.getUniqueId(), translation -> translation.tpa().tpaAcceptAllAccepted(), new Formatter[0]);
    }
}

