/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.spawn;

import com.eternalcode.core.feature.spawn.SpawnJoinSettings;
import com.eternalcode.core.libs.eu.okaeri.configs.OkaeriConfig;
import com.eternalcode.core.libs.eu.okaeri.configs.annotation.Comment;
import java.time.Duration;
import lombok.Generated;

public class SpawnJoinConfig
extends OkaeriConfig
implements SpawnJoinSettings {
    @Comment(value={"# Delay before teleporting player to spawn (in seconds)", "# Set to 0 to teleport instantly"})
    public Duration spawnTeleportTime = Duration.ofSeconds(5L);
    @Comment(value={"# Teleport to spawn on first join (only once, when the player joins the server for the first time)", "# Example: true = teleport new players to spawn automatically"})
    public boolean teleportNewPlayersToSpawn = true;
    @Comment(value={"# Teleport to spawn on every join (excluding first join, which is handled above)", "# Example: true = always teleport players to spawn when they log in"})
    public boolean teleportPlayersToSpawnOnJoin = false;
    @Comment(value={"# Teleport player to spawn after death", "# This only works if 'teleportToPersonalRespawnPoint' is false, or if 'alwaysTeleportToSpawnAfterDeath' is true"})
    public boolean teleportToSpawnAfterDeath = true;
    @Comment(value={"# Teleports player to their personal respawn point (bed, respawn anchor) after death", "# If true, overrides 'teleportToSpawnAfterDeath' unless 'alwaysTeleportToSpawnAfterDeath' is true"})
    public boolean teleportToPersonalRespawnPoint = true;
    @Comment(value={"# Forces teleport to spawn even if player has a personal respawn point", "# This overrides 'teleportToPersonalRespawnPoint' setting"})
    public boolean alwaysTeleportToSpawnAfterDeath = false;

    @Override
    @Generated
    public Duration spawnTeleportTime() {
        return this.spawnTeleportTime;
    }

    @Override
    @Generated
    public boolean teleportNewPlayersToSpawn() {
        return this.teleportNewPlayersToSpawn;
    }

    @Override
    @Generated
    public boolean teleportPlayersToSpawnOnJoin() {
        return this.teleportPlayersToSpawnOnJoin;
    }

    @Override
    @Generated
    public boolean teleportToSpawnAfterDeath() {
        return this.teleportToSpawnAfterDeath;
    }

    @Override
    @Generated
    public boolean teleportToPersonalRespawnPoint() {
        return this.teleportToPersonalRespawnPoint;
    }

    @Override
    @Generated
    public boolean alwaysTeleportToSpawnAfterDeath() {
        return this.alwaysTeleportToSpawnAfterDeath;
    }
}

