/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.serverlinks;

import com.eternalcode.core.compatibility.Compatibility;
import com.eternalcode.core.compatibility.Version;
import com.eternalcode.core.feature.serverlinks.ServerLinksEntry;
import com.eternalcode.core.feature.serverlinks.ServerLinksSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.net.kyori.adventure.text.Component;
import com.eternalcode.core.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.eternalcode.core.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.net.URI;
import java.net.URISyntaxException;
import org.bukkit.ServerLinks;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@Service
@Compatibility(from=@Version(minor=21, patch=0))
public class ServerLinksService {
    private final Plugin plugin;
    private final MiniMessage miniMessage;
    private final ServerLinksSettings serverLinksSettings;

    @Inject
    public ServerLinksService(Plugin plugin, MiniMessage miniMessage, ServerLinksSettings serverLinksSettings) {
        this.plugin = plugin;
        this.miniMessage = miniMessage;
        this.serverLinksSettings = serverLinksSettings;
    }

    public void sendServerLinks(Player player) {
        ServerLinks serverLinks = this.plugin.getServer().getServerLinks().copy();
        for (ServerLinksEntry serverLink : this.serverLinksSettings.serverLinks()) {
            this.parseLinks(serverLinks, serverLink);
        }
        player.sendLinks(serverLinks);
    }

    private URI parseUrl(String url) {
        try {
            if (!url.startsWith("https://") && !url.startsWith("http://")) {
                return null;
            }
            return new URI(url);
        }
        catch (URISyntaxException exception) {
            return null;
        }
    }

    private ServerLinks.ServerLink parseLinks(ServerLinks serverLinks, ServerLinksEntry links) {
        URI url = this.parseUrl(links.address());
        if (url == null) {
            return null;
        }
        Component deserialize = this.miniMessage.deserialize((Object)links.name());
        return serverLinks.addLink(LegacyComponentSerializer.legacySection().serialize(deserialize), url);
    }
}

