/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.powertool;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.resolver.ArgumentResolver;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.shared.Lazy;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;

@LiteArgument(type=String.class, name="powertool_command")
class PowertoolCommandArgument
extends ArgumentResolver<CommandSender, String> {
    public static final String KEY = "powertool_command";
    private final NoticeService noticeService;
    private final Server server;
    private final Lazy<Map<String, Command>> knownCommands;

    @Inject
    PowertoolCommandArgument(NoticeService noticeService, Server server) {
        this.noticeService = noticeService;
        this.server = server;
        this.knownCommands = new Lazy(this::fetchKnownCommands);
    }

    protected ParseResult<String> parse(Invocation<CommandSender> invocation, Argument<String> context, String argument) {
        String[] parts = argument.trim().split("\\s+");
        String mainCommand = parts[0];
        Map knownCommands = (Map)this.knownCommands.get();
        if (!knownCommands.containsKey(mainCommand)) {
            EternalCoreBroadcast invalidCommandNotice = (EternalCoreBroadcast)this.noticeService.create().sender((CommandSender)invocation.sender()).notice(messages -> messages.powertool().invalidCommand());
            return ParseResult.failure((Object)((Object)invalidCommandNotice));
        }
        return ParseResult.success((Object)argument.trim());
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<String> argument, SuggestionContext context) {
        Map knownCommands = (Map)this.knownCommands.get();
        return SuggestionResult.of(knownCommands.keySet());
    }

    private Map<String, Command> fetchKnownCommands() {
        try {
            Field commandMapField = this.server.getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(this.server);
            if (commandMap instanceof SimpleCommandMap) {
                SimpleCommandMap simpleMap = (SimpleCommandMap)commandMap;
                Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommandsField.setAccessible(true);
                Map knownCommands = (Map)knownCommandsField.get(simpleMap);
                return Collections.unmodifiableMap(knownCommands);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException exception) {
            exception.printStackTrace();
        }
        throw new IllegalStateException("CommandMap is not instance of SimpleCommandMap");
    }
}

