/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.near;

import com.eternalcode.core.feature.near.EntityScope;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.litecommand.argument.AbstractViewerArgument;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;

@LiteArgument(type=EntityScope.class, name="entity-scope")
class EntityScopeArgument
extends AbstractViewerArgument<EntityScope> {
    static final String KEY = "entity-scope";
    private static final List<String> SUGGESTIONS = EntityScope.values().stream().map(entityScope -> entityScope.name().toLowerCase(Locale.ROOT)).toList();

    @Inject
    EntityScopeArgument(TranslationManager translationManager) {
        super(translationManager);
    }

    @Override
    public ParseResult<EntityScope> parse(Invocation<CommandSender> invocation, String argument, Translation translation) {
        try {
            EntityScope entityScope = EntityScope.from(argument);
            return ParseResult.success((Object)entityScope);
        }
        catch (IllegalArgumentException exception) {
            return ParseResult.failure((Object)translation.near().invalidEntityType());
        }
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<EntityScope> argument, SuggestionContext context) {
        return SuggestionResult.of(SUGGESTIONS);
    }
}

