/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.ignore;

import com.eternalcode.core.database.AbstractRepositoryOrmLite;
import com.eternalcode.core.database.DatabaseManager;
import com.eternalcode.core.feature.ignore.IgnoreRepository;
import com.eternalcode.core.feature.ignore.IgnoreTable;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Repository;
import com.eternalcode.core.libs.com.eternalcode.commons.scheduler.Scheduler;
import com.eternalcode.core.libs.com.j256.ormlite.dao.Dao;
import com.eternalcode.core.libs.com.j256.ormlite.stmt.DeleteBuilder;
import com.eternalcode.core.libs.com.j256.ormlite.support.ConnectionSource;
import com.eternalcode.core.libs.com.j256.ormlite.table.TableUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@Repository
class IgnoreRepositoryOrmLite
extends AbstractRepositoryOrmLite
implements IgnoreRepository {
    private static final UUID IGNORE_ALL = UUID.nameUUIDFromBytes("*".getBytes());
    private final Dao<IgnoreTable, Long> cachedDao;
    private final LoadingCache<UUID, Set<UUID>> ignores;

    @Inject
    private IgnoreRepositoryOrmLite(DatabaseManager databaseManager, Scheduler scheduler) throws SQLException {
        super(databaseManager, scheduler);
        this.cachedDao = databaseManager.getDao(IgnoreTable.class);
        this.ignores = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(15L)).refreshAfterWrite(Duration.ofMinutes(3L)).build((CacheLoader)new IgnoreLoader());
        TableUtils.createTableIfNotExists((ConnectionSource)databaseManager.connectionSource(), IgnoreTable.class);
    }

    @Override
    public CompletableFuture<Boolean> isIgnored(UUID by, UUID target) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Set uuids = (Set)this.ignores.get((Object)by);
                return uuids.contains(target) || uuids.contains(IGNORE_ALL);
            }
            catch (ExecutionException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    @Override
    public CompletableFuture<Void> ignore(UUID by, UUID target) {
        return CompletableFuture.runAsync(() -> {
            try {
                Set uuids = (Set)this.ignores.get((Object)by);
                if (!uuids.contains(target)) {
                    this.save(IgnoreTable.class, new IgnoreTable(by, target)).thenRun(() -> this.ignores.refresh((Object)by));
                }
            }
            catch (ExecutionException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    @Override
    public CompletableFuture<Void> ignoreAll(UUID by) {
        return this.ignore(by, IGNORE_ALL);
    }

    @Override
    public CompletableFuture<Void> unIgnore(UUID by, UUID target) {
        return this.action(IgnoreTable.class, dao -> {
            DeleteBuilder builder = dao.deleteBuilder();
            builder.where().eq("player_id", (Object)by).and().eq("ignored_id", (Object)target);
            return builder.delete();
        }).thenRun(() -> this.ignores.refresh((Object)by));
    }

    @Override
    public CompletableFuture<Void> unIgnoreAll(UUID by) {
        return this.action(IgnoreTable.class, dao -> {
            DeleteBuilder builder = dao.deleteBuilder();
            builder.where().eq("player_id", (Object)by);
            return builder.delete();
        }).thenRun(() -> this.ignores.refresh((Object)by));
    }

    @Override
    public CompletableFuture<Set<UUID>> getIgnoredPlayers(UUID by) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return (Set)this.ignores.get((Object)by);
            }
            catch (ExecutionException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private class IgnoreLoader
    extends CacheLoader<UUID, Set<UUID>> {
        private IgnoreLoader() {
        }

        @NotNull
        public Set<UUID> load(@NotNull UUID key) throws SQLException {
            return IgnoreRepositoryOrmLite.this.cachedDao.queryBuilder().where().eq("player_id", (Object)key).query().stream().map(ignoreTable -> ignoreTable.ignoredUuid).collect(Collectors.toSet());
        }
    }
}

