/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.home.homeadmin;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.configuration.implementation.PluginConfiguration;
import com.eternalcode.core.feature.home.Home;
import com.eternalcode.core.feature.home.HomeManager;
import com.eternalcode.core.feature.home.homeadmin.PlayerHomeEntry;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.libs.io.papermc.lib.PaperLib;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.translation.TranslationManager;
import com.eternalcode.core.viewer.Viewer;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@Command(name="homeadmin")
@Permission(value={"eternalcore.home.admin"})
class HomeAdminCommand {
    private final HomeManager homeManager;
    private final NoticeService noticeService;
    private final PluginConfiguration pluginConfiguration;
    private final TranslationManager translationManager;

    @Inject
    public HomeAdminCommand(HomeManager homeManager, NoticeService noticeService, PluginConfiguration pluginConfiguration, TranslationManager translationManager) {
        this.homeManager = homeManager;
        this.noticeService = noticeService;
        this.pluginConfiguration = pluginConfiguration;
        this.translationManager = translationManager;
    }

    @Execute(name="sethome")
    @DescriptionDocs(description={"Set home for user"}, arguments={"<user> <home> [location]"})
    void setHome(@Sender Player sender, @Arg(value="target") OfflinePlayer targetPlayer, @Arg(value="home") String homeName, @Arg Optional<Location> location) {
        if (!this.hasPlayerEverJoined(targetPlayer)) {
            this.sendPlayerNeverJoinedNotice(sender, targetPlayer);
            return;
        }
        Location homeLocation = location.orElse(sender.getLocation());
        UUID targetId = targetPlayer.getUniqueId();
        boolean homeExists = this.homeManager.hasHome(targetId, homeName);
        this.homeManager.createHome(targetId, homeName, homeLocation);
        if (homeExists) {
            this.sendHomeOverrideNotice(sender.getUniqueId(), homeName, targetPlayer);
        } else {
            this.sendHomeCreatedNotice(sender.getUniqueId(), homeName, targetPlayer);
        }
    }

    @Execute(name="delhome")
    @DescriptionDocs(description={"Delete home for user"}, arguments={"<user> <home>"})
    void deleteHome(@Sender Player sender, @Arg(value="player home") PlayerHomeEntry playerHomeEntry) {
        Home home = playerHomeEntry.home();
        OfflinePlayer targetPlayer = playerHomeEntry.offlinePlayer();
        UUID targetId = targetPlayer.getUniqueId();
        this.homeManager.deleteHome(targetId, home.getName());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.home().deleteAsAdmin())).placeholder("{HOME}", home.getName())).placeholder("{PLAYER}", targetPlayer.getName())).player(sender.getUniqueId())).send();
    }

    @Execute(name="home")
    @DescriptionDocs(description={"Teleport to user home"}, arguments={"<user> <home>"})
    void home(@Sender Player player, @Arg(value="player home") PlayerHomeEntry playerHomeEntry) {
        Home home = playerHomeEntry.home();
        OfflinePlayer targetPlayer = playerHomeEntry.offlinePlayer();
        PaperLib.teleportAsync((Entity)player, (Location)home.getLocation());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.home().teleportedAsAdmin())).placeholder("{HOME}", home.getName())).placeholder("{PLAYER}", targetPlayer.getName())).player(player.getUniqueId())).send();
    }

    @Execute(name="list")
    @DescriptionDocs(description={"List user homes"}, arguments={"<user>"})
    void list(@Sender Viewer viewer, @Arg(value="target") OfflinePlayer targetPlayer) {
        if (!this.hasPlayerEverJoined(targetPlayer)) {
            this.sendPlayerNeverJoinedNoticeToViewer(viewer, targetPlayer);
            return;
        }
        UUID targetId = targetPlayer.getUniqueId();
        Collection<Home> homes = this.homeManager.getHomes(targetId);
        if (homes.isEmpty()) {
            this.sendNoHomesNotice(viewer, targetPlayer);
            return;
        }
        this.sendHomeListNotice(viewer, homes, targetPlayer);
    }

    private boolean hasPlayerEverJoined(OfflinePlayer player) {
        return player.hasPlayedBefore() || player.isOnline();
    }

    private void sendPlayerNeverJoinedNotice(Player sender, OfflinePlayer targetPlayer) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.argument().offlinePlayer())).placeholder("{PLAYER}", targetPlayer.getName())).player(sender.getUniqueId())).send();
    }

    private void sendPlayerNeverJoinedNoticeToViewer(Viewer viewer, OfflinePlayer targetPlayer) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.argument().offlinePlayer())).placeholder("{PLAYER}", targetPlayer.getName())).viewer(viewer)).send();
    }

    private void sendHomeOverrideNotice(UUID senderId, String homeName, OfflinePlayer targetPlayer) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.home().overrideHomeLocationAsAdmin())).placeholder("{HOME}", homeName)).placeholder("{PLAYER}", targetPlayer.getName())).player(senderId)).send();
    }

    private void sendHomeCreatedNotice(UUID senderId, String homeName, OfflinePlayer targetPlayer) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.home().createAsAdmin())).placeholder("{HOME}", homeName)).placeholder("{PLAYER}", targetPlayer.getName())).player(senderId)).send();
    }

    private void sendNoHomesNotice(Viewer viewer, OfflinePlayer targetPlayer) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.home().noHomesOnListAsAdmin())).placeholder("{PLAYER}", targetPlayer.getName())).viewer(viewer)).send();
    }

    private void sendHomeListNotice(Viewer viewer, Collection<Home> homes, OfflinePlayer targetPlayer) {
        String playerName = targetPlayer.getName();
        String formattedHomes = this.formatHomeList(homes, playerName);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.home().homeListAsAdmin())).placeholder("{HOMES}", formattedHomes)).placeholder("{PLAYER}", playerName)).viewer(viewer)).send();
    }

    private String formatHomeList(Collection<Home> homes, String playerName) {
        String format = this.translationManager.getMessages().home().homeListEntryFormatAsAdmin();
        return homes.stream().map(home -> format.replace("{HOME}", home.getName()).replace("{PLAYER}", playerName)).collect(Collectors.joining(this.pluginConfiguration.format.separator));
    }
}

