/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.butcher;

import com.eternalcode.core.feature.butcher.MobEntity;
import com.eternalcode.core.feature.butcher.MobType;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.litecommand.argument.AbstractViewerArgument;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import com.eternalcode.core.util.EntityUtil;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

@LiteArgument(type=MobEntity.class, name="mobType")
class MobEntityArgument
extends AbstractViewerArgument<MobEntity> {
    static final String KEY = "mobType";

    @Inject
    MobEntityArgument(TranslationManager translationManager) {
        super(translationManager);
    }

    @Override
    public ParseResult<MobEntity> parse(Invocation<CommandSender> invocation, String argument, Translation translation) {
        try {
            MobType mobType = MobType.valueOf(argument.toUpperCase());
            if (mobType.isParseable()) {
                return ParseResult.success((Object)new MobEntity(mobType));
            }
        }
        catch (IllegalArgumentException mobType) {
            // empty catch block
        }
        try {
            EntityType entityType = EntityType.valueOf((String)argument.toUpperCase());
            if (EntityUtil.isMob(entityType)) {
                return ParseResult.success((Object)new MobEntity(MobType.OTHER, entityType.getEntityClass()));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ParseResult.failure((Object)translation.argument().noArgument());
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<MobEntity> argument, SuggestionContext context) {
        Stream<MobType> mobTypeStream = Stream.of(MobType.values()).filter(MobType::isSuggestable);
        Stream<EntityType> entityTypeStream = Stream.of(EntityType.values()).filter(EntityUtil::isMob);
        return (SuggestionResult)Stream.concat(entityTypeStream, mobTypeStream).map(Enum::name).map(String::toLowerCase).collect(SuggestionResult.collector());
    }
}

