/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.litecommand.handler;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteHandler;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.handler.result.ResultHandlerChain;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invalidusage.InvalidUsageHandler;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.schematic.Schematic;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.placeholder.Placeholders;
import com.eternalcode.core.viewer.Viewer;
import com.eternalcode.core.viewer.ViewerService;
import org.bukkit.command.CommandSender;

@LiteHandler(value=InvalidUsage.class)
class InvalidUsageHandlerImpl
implements InvalidUsageHandler<CommandSender> {
    private static final Placeholders<String> SCHEME = Placeholders.of("{USAGE}", scheme -> scheme);
    private final ViewerService viewerService;
    private final NoticeService noticeService;

    @Inject
    InvalidUsageHandlerImpl(ViewerService viewerService, NoticeService noticeService) {
        this.viewerService = viewerService;
        this.noticeService = noticeService;
    }

    public void handle(Invocation<CommandSender> invocation, InvalidUsage<CommandSender> result, ResultHandlerChain<CommandSender> chain) {
        Viewer viewer = this.viewerService.any(invocation.sender());
        Schematic schematic = result.getSchematic();
        if (schematic.isOnlyFirst()) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().viewer(viewer)).notice(translation -> translation.argument().usageMessage())).placeholders(SCHEME, schematic.first()).send();
            return;
        }
        this.noticeService.viewer(viewer, translation -> translation.argument().usageMessageHead(), new Formatter[0]);
        for (String schema : schematic.all()) {
            this.noticeService.viewer(viewer, translation -> translation.argument().usageMessageEntry(), new Formatter[]{SCHEME.toFormatter(schema)});
        }
    }
}

