/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.litecommand.contextual;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteContextual;
import com.eternalcode.core.libs.com.eternalcode.multification.notice.Notice;
import com.eternalcode.core.libs.dev.rollczi.litecommands.context.ContextProvider;
import com.eternalcode.core.libs.dev.rollczi.litecommands.context.ContextResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import com.eternalcode.core.user.User;
import com.eternalcode.core.user.UserManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@LiteContextual(value=User.class)
class UserContextual
implements ContextProvider<CommandSender, User> {
    private final TranslationManager translationManager;
    private final UserManager userManager;

    @Inject
    UserContextual(TranslationManager translationManager, UserManager userManager) {
        this.translationManager = translationManager;
        this.userManager = userManager;
    }

    public ContextResult<User> provide(Invocation<CommandSender> invocation) {
        Object object = invocation.sender();
        if (object instanceof Player) {
            Player player = (Player)object;
            return ContextResult.ok(() -> this.userManager.getUser(player.getUniqueId()).orElseThrow(() -> new IllegalStateException("Player " + player.getName() + " is not registered!")));
        }
        Translation translation = this.translationManager.getMessages();
        Notice onlyPlayer = translation.argument().onlyPlayer();
        return ContextResult.error((Object)onlyPlayer);
    }
}

