/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.weather;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.scheduler.MinecraftScheduler;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Context;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.World;

@Command(name="sun")
@Permission(value={"eternalcore.sun"})
class SunCommand {
    private final NoticeService noticeService;
    private final MinecraftScheduler scheduler;

    @Inject
    SunCommand(NoticeService noticeService, MinecraftScheduler scheduler) {
        this.noticeService = noticeService;
        this.scheduler = scheduler;
    }

    @Execute
    @DescriptionDocs(description={"Sets weather to sun in current world"})
    void sun(@Sender Viewer viewer, @Context World world) {
        this.setSun(viewer, world);
    }

    @Execute
    @DescriptionDocs(description={"Sets weather to sun in specified world"}, arguments={"<world>"})
    void sunWorld(@Sender Viewer viewer, @Arg World world) {
        this.setSun(viewer, world);
    }

    private void setSun(Viewer viewer, World world) {
        this.scheduler.run(() -> {
            world.setClearWeatherDuration(12000);
            world.setStorm(false);
            world.setThundering(false);
        });
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().viewer(viewer)).placeholder("{WORLD}", world.getName())).notice(translation -> translation.timeAndWeather().weatherSetSun())).send();
    }
}

