/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.warp.repository;

import com.eternalcode.core.configuration.ConfigurationManager;
import com.eternalcode.core.feature.warp.Warp;
import com.eternalcode.core.feature.warp.WarpImpl;
import com.eternalcode.core.feature.warp.repository.WarpConfig;
import com.eternalcode.core.feature.warp.repository.WarpRepository;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Repository;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.PositionAdapter;
import com.eternalcode.core.libs.com.eternalcode.commons.scheduler.Scheduler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Location;

@Repository
class WarpRepositoryImpl
implements WarpRepository {
    private static final Object READ_WRITE_LOCK = new Object();
    private final WarpConfig warpConfig;
    private final ConfigurationManager configurationManager;
    private final Scheduler scheduler;

    @Inject
    WarpRepositoryImpl(ConfigurationManager configurationManager, WarpConfig warpConfig, Scheduler scheduler) {
        this.configurationManager = configurationManager;
        this.warpConfig = warpConfig;
        this.scheduler = scheduler;
    }

    @Override
    public CompletableFuture<Void> saveWarp(Warp warp) {
        WarpConfig.WarpConfigEntry warpConfigEntry = new WarpConfig.WarpConfigEntry(PositionAdapter.convert((Location)warp.getLocation()), warp.getPermissions());
        return this.transactionalRun(warps -> warps.put(warp.getName(), warpConfigEntry));
    }

    @Override
    public CompletableFuture<Void> removeWarp(String warp) {
        return this.transactionalRun(warps -> warps.remove(warp));
    }

    @Override
    public CompletableFuture<Optional<Warp>> getWarp(String name) {
        return this.transactionalSupply(warps -> Optional.ofNullable(this.warpConfig.warps.get(name)).map(warpConfigEntry -> new WarpImpl(name, warpConfigEntry.position, warpConfigEntry.permissions)));
    }

    @Override
    public CompletableFuture<List<Warp>> getWarps() {
        return this.transactionalSupply(warps -> warps.entrySet().stream().map(warpConfigEntry -> {
            WarpConfig.WarpConfigEntry warpContextual = (WarpConfig.WarpConfigEntry)warpConfigEntry.getValue();
            return new WarpImpl((String)warpConfigEntry.getKey(), warpContextual.position, warpContextual.permissions);
        }).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> transactionalRun(Consumer<Map<String, WarpConfig.WarpConfigEntry>> editor) {
        return this.transactionalSupply(warps -> {
            editor.accept((Map<String, WarpConfig.WarpConfigEntry>)warps);
            return null;
        });
    }

    private <T> CompletableFuture<T> transactionalSupply(Function<Map<String, WarpConfig.WarpConfigEntry>, T> editor) {
        return this.scheduler.completeAsync(() -> {
            Object object = READ_WRITE_LOCK;
            synchronized (object) {
                HashMap<String, WarpConfig.WarpConfigEntry> warps = new HashMap<String, WarpConfig.WarpConfigEntry>(this.warpConfig.warps);
                Object result = editor.apply(warps);
                this.warpConfig.warps = warps;
                this.configurationManager.save(this.warpConfig);
                return result;
            }
        });
    }
}

