/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.warp.command;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.warp.Warp;
import com.eternalcode.core.feature.warp.WarpService;
import com.eternalcode.core.feature.warp.inventory.WarpInventory;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import org.bukkit.entity.Player;

@Command(name="delwarp")
@Permission(value={"eternalcore.delwarp"})
class DelWarpCommand {
    private final WarpService warpService;
    private final NoticeService noticeService;
    private final WarpInventory warpInventory;

    @Inject
    DelWarpCommand(WarpService warpService, NoticeService noticeService, WarpInventory warpInventory) {
        this.warpService = warpService;
        this.noticeService = noticeService;
        this.warpInventory = warpInventory;
    }

    @Execute
    @DescriptionDocs(description={"Remove warp"}, arguments={"<warp>"})
    void remove(@Sender Player player, @Arg Warp warp) {
        String name = warp.getName();
        this.removeWarp(player, name);
    }

    private void removeWarp(Player player, String name) {
        if (!this.warpService.exists(name)) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.warp().notExist())).placeholder("{WARP}", name)).send();
            return;
        }
        this.warpService.removeWarp(name);
        this.warpInventory.removeWarp(name);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.warp().remove())).placeholder("{WARP}", name)).send();
    }
}

