/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.teleportrequest.self;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.teleport.TeleportTaskService;
import com.eternalcode.core.feature.teleportrequest.TeleportRequestSettings;
import com.eternalcode.core.feature.teleportrequest.self.TeleportHereRequestService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.PositionAdapter;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.RootCommand;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

@RootCommand
class TpaHereActionCommand {
    private final TeleportHereRequestService requestService;
    private final TeleportTaskService teleportTaskService;
    private final TeleportRequestSettings settings;
    private final NoticeService noticeService;
    private final Server server;

    @Inject
    TpaHereActionCommand(TeleportHereRequestService requestService, TeleportTaskService teleportTaskService, TeleportRequestSettings settings, NoticeService noticeService, Server server) {
        this.requestService = requestService;
        this.teleportTaskService = teleportTaskService;
        this.settings = settings;
        this.noticeService = noticeService;
        this.server = server;
    }

    @Execute(name="tpahereaccept")
    @Permission(value={"eternalcore.tpaccept"})
    void accept(@Sender Player player, @Arg(value="selfrequester") Player target) {
        this.teleportTaskService.createTeleport(player.getUniqueId(), PositionAdapter.convert((Location)player.getLocation()), PositionAdapter.convert((Location)target.getLocation()), this.settings.tpaTimer());
        this.requestService.removeRequest(target.getUniqueId());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.tpa().tpaAcceptMessage())).placeholder("{PLAYER}", target.getName())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(target.getUniqueId())).notice(translation -> translation.tpa().tpaAcceptReceivedMessage())).placeholder("{PLAYER}", player.getName())).send();
    }

    @Execute(name="tpaheredeny")
    @Permission(value={"eternalcore.tpahere.deny"})
    @DescriptionDocs(description={"Deny a teleport here request"})
    void executeTarget(@Sender Player player, @Arg(value="selfrequester") Player target) {
        this.requestService.removeRequest(target.getUniqueId());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.tpa().tpaDenyDoneMessage())).placeholder("{PLAYER}", target.getName())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(target.getUniqueId())).notice(translation -> translation.tpa().tpaDenyReceivedMessage())).placeholder("{PLAYER}", player.getName())).send();
    }

    @Execute(name="tpaheredeny -all")
    @Permission(value={"eternalcore.tpahere.deny"})
    @DescriptionDocs(description={"Deny all teleport here requests"})
    void executeAll(@Sender Player player) {
        List<UUID> requests = this.requestService.findRequests(player.getUniqueId());
        if (requests.isEmpty()) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.tpa().tpaDenyNoRequestMessage(), new Formatter[0]);
            return;
        }
        for (UUID uniqueId : requests) {
            Player requester = this.server.getPlayer(uniqueId);
            this.requestService.removeRequest(uniqueId);
            if (requester == null) continue;
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(uniqueId)).notice(translation -> translation.tpa().tpaDenyReceivedMessage())).placeholder("{PLAYER}", player.getName())).send();
        }
        this.noticeService.player(player.getUniqueId(), translation -> translation.tpa().tpaDenyAllDenied(), new Formatter[0]);
    }
}

