/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.quitmessage;

import com.eternalcode.core.feature.vanish.VanishService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Controller;
import com.eternalcode.core.libs.com.eternalcode.commons.RandomElementUtil;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

@Controller
class PlayerQuitMessageController
implements Listener {
    private static final String EMPTY_MESSAGE = null;
    private final NoticeService noticeService;
    private final VanishService vanishService;

    @Inject
    PlayerQuitMessageController(NoticeService noticeService, VanishService vanishService) {
        this.noticeService = noticeService;
        this.vanishService = vanishService;
    }

    @EventHandler
    void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.vanishService.isVanished(player)) {
            event.setQuitMessage(EMPTY_MESSAGE);
            return;
        }
        event.setQuitMessage(EMPTY_MESSAGE);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().noticeOptional(translation -> RandomElementUtil.randomElement(translation.quit().playerLeftServer()))).placeholder("{PLAYER}", player.getName())).onlinePlayers()).sendAsync();
    }
}

