/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.jail;

import com.eternalcode.core.feature.jail.JailService;
import com.eternalcode.core.feature.jail.JailSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Controller;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

@Controller
class JailController
implements Listener {
    private static final Set<PlayerTeleportEvent.TeleportCause> CANCELLED_CAUSES = Set.of(PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT, PlayerTeleportEvent.TeleportCause.COMMAND, PlayerTeleportEvent.TeleportCause.ENDER_PEARL);
    private final JailService jailService;
    private final JailSettings jailSettings;
    private final NoticeService noticeService;

    @Inject
    public JailController(JailService jailService, JailSettings jailSettings, NoticeService noticeService) {
        this.jailService = jailService;
        this.noticeService = noticeService;
        this.jailSettings = jailSettings;
    }

    @EventHandler
    public void onPlayerPreCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (!this.jailService.isPlayerJailed(player.getUniqueId())) {
            return;
        }
        if (player.hasPermission("eternalcore.jail.bypass")) {
            return;
        }
        String command = event.getMessage().split(" ")[0].substring(1);
        if (this.jailSettings.allowedCommands().contains(command)) {
            return;
        }
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.jailSection().jailCannotUseCommand())).player(player.getUniqueId())).send();
        event.setCancelled(true);
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent teleportEvent) {
        UUID uniqueId = teleportEvent.getPlayer().getUniqueId();
        if (!this.jailService.isPlayerJailed(uniqueId)) {
            return;
        }
        if (CANCELLED_CAUSES.contains(teleportEvent.getCause())) {
            teleportEvent.setCancelled(true);
        }
    }
}

