/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.item;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.give.GiveService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Context;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.util.MaterialUtil;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(name="item", aliases={"i"})
@Permission(value={"eternalcore.item"})
class ItemCommand {
    private static final int DEFAULT_AMOUNT = 1;
    private final NoticeService noticeService;
    private final GiveService giveService;

    @Inject
    ItemCommand(NoticeService noticeService, GiveService giveService) {
        this.noticeService = noticeService;
        this.giveService = giveService;
    }

    @Execute
    @DescriptionDocs(description={"Gives you an item"}, arguments={"<item>"})
    void execute(@Context Player player, @Arg Material material) {
        this.execute(player, material, 1);
    }

    @Execute
    @DescriptionDocs(description={"Gives an item with a custom amount"}, arguments={"<item> [amount]"})
    void execute(@Context Player player, @Arg Material material, @Arg(value="amount") int amount) {
        boolean isSuccess = this.giveService.giveItem((CommandSender)player, player, material, amount);
        if (isSuccess) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().placeholder("{ITEM}", MaterialUtil.format(material))).notice(translation -> translation.give().itemGivenByAdmin())).player(player.getUniqueId())).send();
        }
    }
}

