/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.ignore;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.ignore.IgnoreResult;
import com.eternalcode.core.feature.ignore.IgnoreService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.commons.concurrent.FutureHandler;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Context;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.user.User;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

@Command(name="unignore")
@Permission(value={"eternalcore.ignore"})
class UnIgnoreCommand {
    private final IgnoreService ignoreService;
    private final NoticeService noticeService;

    @Inject
    public UnIgnoreCommand(IgnoreService ignoreService, NoticeService noticeService) {
        this.ignoreService = ignoreService;
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Unignore specified player"}, arguments={"<player>"})
    void unignore(@Context User sender, @Arg(value="ignored_player") User target) {
        UUID senderUuid = sender.getUniqueId();
        UUID targetUuid = target.getUniqueId();
        if (sender.equals(target)) {
            this.noticeService.viewer(sender, translation -> translation.ignore().cannotUnignoreSelf(), new Formatter[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)this.ignoreService.isIgnored(senderUuid, targetUuid).thenCompose(isIgnored -> {
            if (!isIgnored.booleanValue()) {
                ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().user(sender).placeholder("{PLAYER}", target.getName())).notice(translation -> translation.ignore().playerNotIgnored())).send();
                return CompletableFuture.completedFuture(IgnoreResult.CANCELLED);
            }
            return this.ignoreService.unIgnore(senderUuid, targetUuid);
        })).thenAccept(result -> {
            if (result == IgnoreResult.SUCCESS) {
                ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(senderUuid)).placeholder("{PLAYER}", target.getName())).notice(translation -> translation.ignore().playerUnignored())).send();
            }
        })).exceptionally(FutureHandler::handleException);
    }

    @Execute(name="-all", aliases={"*"})
    @DescriptionDocs(description={"Unignore all players"})
    void unIgnoreAll(@Context User sender) {
        UUID senderUuid = sender.getUniqueId();
        ((CompletableFuture)this.ignoreService.unIgnoreAll(senderUuid).thenAccept(result -> {
            if (result == IgnoreResult.SUCCESS) {
                ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(senderUuid)).notice(translation -> translation.ignore().allPlayersUnignored())).send();
            }
        })).exceptionally(FutureHandler::handleException);
    }
}

