/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.customcommand;

import com.eternalcode.core.feature.customcommand.CustomCommand;
import com.eternalcode.core.feature.customcommand.CustomCommandBukkitWrapper;
import com.eternalcode.core.feature.customcommand.CustomCommandConfig;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.notice.NoticeService;
import java.lang.reflect.Field;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;

@Service
public class CustomCommandRegistry {
    private static final String FALLBACK_PREFIX = "eternalcore";
    private final CustomCommandConfig customCommandConfig;
    private final NoticeService noticeService;
    private final Server server;
    private CommandMap commandMap;

    @Inject
    public CustomCommandRegistry(CustomCommandConfig customCommandConfig, NoticeService noticeService, Server server) {
        this.customCommandConfig = customCommandConfig;
        this.noticeService = noticeService;
        this.server = server;
        this.registerCustomCommands();
    }

    public void registerCustomCommands() {
        for (CustomCommand customCommand : this.customCommandConfig.commands) {
            this.registerCustomCommand(customCommand);
        }
    }

    private void registerCustomCommand(CustomCommand customCommand) {
        CustomCommandBukkitWrapper customCommandBukkitWrapper = new CustomCommandBukkitWrapper(customCommand.getName(), customCommand.getAliases(), this.noticeService, customCommand.getMessage(), customCommand.getCommands());
        this.commandMap().register(FALLBACK_PREFIX, (Command)customCommandBukkitWrapper);
    }

    CommandMap commandMap() {
        if (this.commandMap == null) {
            try {
                Field commandMapField = this.server.getClass().getDeclaredField("commandMap");
                commandMapField.setAccessible(true);
                this.commandMap = (CommandMap)commandMapField.get(this.server);
            }
            catch (IllegalAccessException | NoSuchFieldException exception) {
                throw new RuntimeException("Failed to get CommandMap from the server, this might be due to a server version incompatibility.", exception);
            }
        }
        return this.commandMap;
    }
}

