/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.clear;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@Command(name="clear")
@Permission(value={"eternalcore.clear"})
class InventoryClearCommand {
    private final NoticeService noticeService;

    @Inject
    InventoryClearCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Clears your inventory"})
    void execute(@Sender Player player) {
        this.clear(player);
    }

    @Execute
    @DescriptionDocs(description={"Clears inventory of player"}, arguments={"<player>"})
    @Permission(value={"eternalcore.clear.other"})
    void execute(@Sender Viewer audience, @Arg Player target) {
        this.clear(target);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.clear().targetInventoryCleared())).placeholder("{PLAYER}", target.getName())).viewer(audience)).send();
    }

    private void clear(Player player) {
        player.getInventory().setArmorContents(new ItemStack[0]);
        player.getInventory().clear();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.clear().inventoryCleared())).player(player.getUniqueId())).send();
    }
}

