/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.annotations.scan.reflect;

import com.eternalcode.annotations.scan.reflect.PackageStack;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class PackageUtil {
    public static PackageStack createPackageStack(Package packageToSearch, ClassLoader classLoader) {
        return PackageUtil.resolvePackageStack(packageToSearch, classLoader).packageStack();
    }

    private static Result resolvePackageStack(Package packageToSearch, ClassLoader classLoader) {
        String packageName = packageToSearch.getName();
        try {
            PackageStack packageStack = PackageStack.empty(packageToSearch);
            ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
            ImmutableSet classes = classPath.getTopLevelClassesRecursive(packageName);
            ArrayList<String> loadedPackages = new ArrayList<String>();
            for (ClassPath.ClassInfo info : classes) {
                String subPackageName = info.getPackageName();
                if (subPackageName.equals(packageName)) {
                    try {
                        Class<?> clazz = Class.forName(info.getName(), false, classLoader);
                        packageStack = packageStack.withClass(clazz);
                    }
                    catch (NoClassDefFoundError error) {}
                    continue;
                }
                if (loadedPackages.contains(subPackageName)) continue;
                try {
                    Class.forName(info.getName(), false, classLoader);
                }
                catch (NoClassDefFoundError error) {
                    continue;
                }
                Package subPackage = classLoader.getDefinedPackage(subPackageName);
                Result result = PackageUtil.resolvePackageStack(subPackage, classLoader);
                PackageStack subPackageStack = result.packageStack();
                loadedPackages.addAll(result.loadedPackages());
                if (!subPackageStack.getClasses().isEmpty() || !subPackageStack.getSubPackages().isEmpty()) {
                    packageStack = packageStack.withSubPackage(subPackageStack);
                }
                loadedPackages.add(subPackageName);
            }
            return new Result(packageStack, loadedPackages);
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }

    private record Result(PackageStack packageStack, List<String> loadedPackages) {
    }
}

