/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.util;

import java.util.Map;
import java.util.Optional;

public final class MapUtil {
    private MapUtil() {
    }

    public static <E> Optional<E> findByInstanceOf(Class<?> type, Map<Class<?>, E> map) {
        E element = map.get(type);
        if (element != null) {
            return Optional.of(element);
        }
        for (Map.Entry<Class<?>, E> entry : map.entrySet()) {
            if (!type.isAssignableFrom(entry.getKey())) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public static <E> Optional<E> findBySuperTypeOf(Class<?> type, Map<Class<?>, E> map) {
        Optional<E> elementBySuperClass = MapUtil.findKeySuperTypeOf0(type, map);
        if (elementBySuperClass.isPresent()) {
            return elementBySuperClass;
        }
        for (Class<?> anInterface : type.getInterfaces()) {
            E elementByInterface = map.get(anInterface);
            if (elementByInterface == null) continue;
            return Optional.of(elementByInterface);
        }
        E elementByObject = map.get(Object.class);
        if (elementByObject != null) {
            return Optional.of(elementByObject);
        }
        return Optional.empty();
    }

    private static <E> Optional<E> findKeySuperTypeOf0(Class<?> type, Map<Class<?>, E> map) {
        Optional<E> option;
        E element = map.get(type);
        if (element != null) {
            return Optional.of(element);
        }
        Class<?> superclass = type.getSuperclass();
        if (superclass != null && superclass != Object.class && (option = MapUtil.findBySuperTypeOf(superclass, map)).isPresent()) {
            return option;
        }
        return Optional.empty();
    }
}

