/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.translation;

import com.eternalcode.core.configuration.ConfigurationManager;
import com.eternalcode.core.injector.annotations.Bean;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Setup;
import com.eternalcode.core.translation.AbstractTranslation;
import com.eternalcode.core.translation.Language;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import com.eternalcode.core.translation.TranslationSettings;
import com.eternalcode.core.translation.implementation.TranslationFactory;
import java.util.HashMap;

@Setup
class TranslationManagerSetup {
    private final TranslationSettings translationSettings;

    @Inject
    TranslationManagerSetup(TranslationSettings translationSettings) {
        this.translationSettings = translationSettings;
    }

    @Bean
    TranslationManager translationManager(ConfigurationManager configurationManager) {
        HashMap<Language, Translation> translations = new HashMap<Language, Translation>();
        AbstractTranslation enTranslation = TranslationFactory.create(Language.EN);
        configurationManager.load(enTranslation);
        translations.put(Language.EN, enTranslation);
        if (!this.translationSettings.language().equals((Object)Language.EN)) {
            AbstractTranslation selectedTranslation = TranslationFactory.create(this.translationSettings.language());
            configurationManager.load(selectedTranslation);
            translations.put(this.translationSettings.language(), selectedTranslation);
        }
        return new TranslationManager(translations, this.translationSettings.language());
    }
}

