/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.teleportrandomplayer;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.teleportrandomplayer.TeleportRandomPlayerService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.libs.io.papermc.lib.PaperLib;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@Command(name="teleportorandomplayer", aliases={"tprp"})
@Permission(value={"eternalcode.tprp"})
public class TeleportToRandomPlayerCommand {
    private final TeleportRandomPlayerService randomPlayerService;
    private final NoticeService noticeService;

    @Inject
    public TeleportToRandomPlayerCommand(TeleportRandomPlayerService randomPlayerService, NoticeService noticeService) {
        this.randomPlayerService = randomPlayerService;
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Teleport to a player who hasn't been teleported to recently, ensuring fair distribution"})
    void execute(@Sender Player player) {
        Player targetPlayer = this.randomPlayerService.findLeastRecentlyTeleportedPlayer(player);
        if (targetPlayer == null || !targetPlayer.isOnline()) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.teleportToRandomPlayer().randomPlayerNotFound())).send();
            return;
        }
        this.randomPlayerService.updateTeleportationHistory(player, targetPlayer);
        PaperLib.teleportAsync((Entity)player, (Location)targetPlayer.getLocation());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.teleportToRandomPlayer().teleportedToRandomPlayer())).placeholder("{PLAYER}", targetPlayer.getName())).send();
    }

    @Execute
    @DescriptionDocs(description={"Teleport to a player who is within specified Y range and hasn't been teleported to recently"})
    void executeWithYRange(@Sender Player player, @Arg int minY, @Arg int maxY) {
        if (minY > maxY) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.teleportToRandomPlayer().randomPlayerInRangeNotFound())).send();
            return;
        }
        Player targetPlayer = this.randomPlayerService.findLeastRecentlyTeleportedPlayerByY(player, minY, maxY);
        if (targetPlayer == null || !targetPlayer.isOnline()) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.teleportToRandomPlayer().randomPlayerInRangeNotFound())).send();
            return;
        }
        this.randomPlayerService.updateTeleportationHistory(player, targetPlayer);
        PaperLib.teleportAsync((Entity)player, (Location)targetPlayer.getLocation());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.teleportToRandomPlayer().teleportedToRandomPlayerInRange())).placeholder("{PLAYER}", targetPlayer.getName())).placeholder("{Y}", String.valueOf((int)targetPlayer.getLocation().getY()))).send();
    }
}

