/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.randomteleport;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.delay.Delay;
import com.eternalcode.core.feature.randomteleport.RandomTeleportPlaceholders;
import com.eternalcode.core.feature.randomteleport.RandomTeleportService;
import com.eternalcode.core.feature.randomteleport.RandomTeleportSettings;
import com.eternalcode.core.feature.randomteleport.RandomTeleportTaskService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.util.DurationUtil;
import com.eternalcode.core.viewer.Viewer;
import java.time.Duration;
import java.util.UUID;
import org.bukkit.entity.Player;

@Command(name="rtp", aliases={"randomteleport"})
class RandomTeleportCommand {
    private final NoticeService noticeService;
    private final RandomTeleportService randomTeleportService;
    private final RandomTeleportTaskService randomTeleportTaskService;
    private final RandomTeleportSettings randomTeleportSettings;
    private final Delay<UUID> cooldown;

    @Inject
    RandomTeleportCommand(NoticeService noticeService, RandomTeleportService randomTeleportService, RandomTeleportTaskService randomTeleportTaskService, RandomTeleportSettings randomTeleportSettings) {
        this.noticeService = noticeService;
        this.randomTeleportService = randomTeleportService;
        this.randomTeleportTaskService = randomTeleportTaskService;
        this.randomTeleportSettings = randomTeleportSettings;
        this.cooldown = Delay.withDefault(() -> this.randomTeleportSettings.cooldown());
    }

    @Execute
    @Permission(value={"eternalcore.rtp"})
    @DescriptionDocs(description={"Teleportation of the sender to a random location, if you want bypass cooldown use eternalcore.rtp.bypass permission"})
    void executeSelf(@Sender Player player) {
        UUID uuid = player.getUniqueId();
        if (this.hasRandomTeleportDelay(player)) {
            return;
        }
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.randomTeleport().randomTeleportStarted())).player(player.getUniqueId())).send();
        this.randomTeleportTaskService.createTeleport(player).whenCompleteAsync((result, error) -> {
            if (error != null || !result.success()) {
                this.handleTeleportFailure(player);
                return;
            }
            this.handleTeleportSuccess(player);
        });
        this.cooldown.markDelay(uuid);
    }

    @Execute
    @Permission(value={"eternalcore.rtp.other"})
    @DescriptionDocs(description={"Teleportation of a player to a random location."}, arguments={"<player>"})
    void executeOther(@Sender Viewer sender, @Arg Player player) {
        UUID uuid = player.getUniqueId();
        if (this.hasRandomTeleportDelay(player)) {
            return;
        }
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.randomTeleport().randomTeleportStarted())).player(player.getUniqueId())).send();
        this.randomTeleportService.teleport(player).whenCompleteAsync((result, error) -> {
            if (error != null || !result.success()) {
                this.handleTeleportFailure(player);
                return;
            }
            this.handleAdminTeleport(sender, player);
        });
        this.cooldown.markDelay(uuid);
    }

    private void handleTeleportSuccess(Player player) {
        this.noticeService.player(player.getUniqueId(), translation -> translation.randomTeleport().teleportedToRandomLocation(), new Formatter[]{RandomTeleportPlaceholders.PLACEHOLDERS.toFormatter(player)});
    }

    private void handleTeleportFailure(Player player) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.randomTeleport().randomTeleportFailed())).player(player.getUniqueId())).send();
    }

    private void handleAdminTeleport(Viewer sender, Player player) {
        this.noticeService.viewer(sender, translation -> translation.randomTeleport().teleportedSpecifiedPlayerToRandomLocation(), new Formatter[]{RandomTeleportPlaceholders.PLACEHOLDERS.toFormatter(player)});
    }

    private boolean hasRandomTeleportDelay(Player player) {
        UUID uniqueId = player.getUniqueId();
        if (player.hasPermission("eternalcore.rtp.bypass") || player.isOp()) {
            return false;
        }
        if (this.cooldown.hasDelay(uniqueId)) {
            Duration time = this.cooldown.getRemaining(uniqueId);
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.randomTeleport().randomTeleportDelay())).placeholder("{TIME}", DurationUtil.format(time, true))).player(uniqueId)).send();
            return true;
        }
        return false;
    }
}

