/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.powertool;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Key;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.join.Join;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

@Command(name="powertool")
@Permission(value={"eternalcore.powertool.assign"})
public class PowertoolCommand {
    public static final String KEY = "eternalcore_powertool";
    private final NamespacedKey key;
    private final Plugin plugin;
    private final NoticeService noticeService;

    @Inject
    PowertoolCommand(Plugin plugin, NoticeService noticeService) {
        this.plugin = plugin;
        this.noticeService = noticeService;
        this.key = new NamespacedKey(this.plugin, KEY);
    }

    @Execute
    void clear(@Sender Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        ItemMeta meta = item.getItemMeta();
        if (item.getType() == Material.AIR || meta == null) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.powertool().noItemInMainHand())).send();
            return;
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        if (persistentDataContainer.has(this.key, PersistentDataType.STRING)) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.powertool().removed())).placeholder("{ITEM}", item.getType().name())).placeholder("{COMMAND}", (String)persistentDataContainer.get(this.key, PersistentDataType.STRING))).send();
            persistentDataContainer.remove(this.key);
            item.setItemMeta(meta);
            return;
        }
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.powertool().notAssigned())).placeholder("{ITEM}", item.getType().name())).send();
    }

    @Execute
    void assign(@Sender Player player, @Join @Key(value="powertool_command") String command) {
        if (command.trim().isEmpty()) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.powertool().emptyCommand())).send();
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        ItemMeta meta = item.getItemMeta();
        if (item.getType() == Material.AIR || meta == null) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.powertool().noItemInMainHand())).send();
            return;
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        persistentDataContainer.set(this.key, PersistentDataType.STRING, (Object)command);
        item.setItemMeta(meta);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.powertool().assigned())).placeholder("{ITEM}", item.getType().name())).placeholder("{COMMAND}", command)).send();
    }
}

