/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.kill;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.scheduler.MinecraftScheduler;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@Command(name="kill")
@Permission(value={"eternalcore.kill"})
class KillCommand {
    private final NoticeService noticeService;
    private final MinecraftScheduler scheduler;

    @Inject
    KillCommand(NoticeService noticeService, MinecraftScheduler scheduler) {
        this.noticeService = noticeService;
        this.scheduler = scheduler;
    }

    @Execute
    @DescriptionDocs(description={"Kill yourself"})
    void execute(@Sender Player player) {
        player.setHealth(0.0);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.kill().killedYourself())).placeholder("{PLAYER}", player.getName())).player(player.getUniqueId())).send();
    }

    @Execute
    @DescriptionDocs(description={"Kill specified player"}, arguments={"<player>"})
    void execute(@Sender Viewer audience, @Arg Player player) {
        this.scheduler.run((Entity)player, () -> player.setHealth(0.0));
        this.noticeService.player(player.getUniqueId(), translation -> translation.kill().killedByAdmin(), new Formatter[0]);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.kill().killedTargetPlayer())).placeholder("{PLAYER}", player.getName())).viewer(audience)).send();
    }
}

