/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.fun.demoscreen;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.compatibility.Compatibility;
import com.eternalcode.core.compatibility.Version;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import org.bukkit.entity.Player;

@Command(name="demoscreen", aliases={"demo"})
@Permission(value={"eternalcore.troll.demoscreen"})
@Compatibility(from=@Version(minor=18, patch=2))
public class DemoScreenCommand {
    private final NoticeService noticeService;

    @Inject
    public DemoScreenCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Show a demo screen to yourself"})
    void self(@Sender Player sender) {
        sender.showDemoScreen();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.demoScreen().shownToSelf())).player(sender.getUniqueId())).send();
    }

    @Execute
    @DescriptionDocs(description={"Show a demo screen to a player"}, arguments={"<player>"})
    void other(@Sender Player sender, @Arg Player target) {
        target.showDemoScreen();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.demoScreen().shownToOtherPlayer())).player(sender.getUniqueId())).placeholder("{PLAYER}", target.getName())).send();
    }
}

