/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.enchant;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.enchant.EnchantSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.UUID;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@Command(name="enchant")
@Permission(value={"eternalcore.enchant"})
class EnchantCommand {
    private final EnchantSettings enchantSettings;
    private final NoticeService noticeService;

    @Inject
    EnchantCommand(EnchantSettings enchantSettings, NoticeService noticeService) {
        this.enchantSettings = enchantSettings;
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Enchants item in hand"}, arguments={"<enchantment> <level>"})
    void execute(@Sender Player player, @Arg Enchantment enchantment, @Arg(value="enchant-level") int level) {
        PlayerInventory playerInventory = player.getInventory();
        ItemStack handItem = playerInventory.getItem(playerInventory.getHeldItemSlot());
        if (handItem == null) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.argument().noItem())).send();
            return;
        }
        this.enchantItem(player.getUniqueId(), handItem, enchantment, level);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.enchant().enchantedItem())).send();
    }

    @Execute
    @DescriptionDocs(description={"Enchants item in hand"}, arguments={"<enchantment> <level> <player>"})
    void execute(@Sender Player sender, @Arg Enchantment enchantment, @Arg(value="enchant-level") int level, @Arg Player target) {
        PlayerInventory targetInventory = target.getInventory();
        ItemStack handItem = targetInventory.getItem(targetInventory.getHeldItemSlot());
        if (handItem == null) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(sender.getUniqueId())).notice(translation -> translation.argument().noItem())).send();
            return;
        }
        this.enchantItem(sender.getUniqueId(), handItem, enchantment, level);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(sender.getUniqueId())).notice(translation -> translation.enchant().enchantedTargetPlayerItem())).placeholder("{PLAYER}", target.getName())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(target.getUniqueId())).notice(translation -> translation.enchant().enchantedItemByAdmin())).placeholder("{PLAYER}", sender.getName())).send();
    }

    private void enchantItem(UUID playerId, ItemStack item, Enchantment enchantment, int level) {
        if (this.enchantSettings.unsafeEnchantments()) {
            item.addUnsafeEnchantment(enchantment, level);
            return;
        }
        if (enchantment.getStartLevel() > level || enchantment.getMaxLevel() < level || !enchantment.canEnchantItem(item)) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(playerId)).notice(translation -> translation.enchant().enchantmentLevelUnsupported())).send();
            return;
        }
        item.addEnchantment(enchantment, level);
    }
}

