/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.chat;

import com.eternalcode.core.feature.chat.ChatService;
import com.eternalcode.core.feature.chat.ChatSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.com.github.benmanes.caffeine.cache.Cache;
import com.eternalcode.core.libs.com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.entity.Player;

@Service
class ChatServiceImpl
implements ChatService {
    private final ChatSettings chatSettings;
    private final Server server;
    private final Cache<UUID, Instant> slowdown;

    @Inject
    ChatServiceImpl(ChatSettings chatSettings, Server server) {
        this.chatSettings = chatSettings;
        this.server = server;
        this.slowdown = Caffeine.newBuilder().expireAfterWrite(this.chatSettings.chatDelay().plus(Duration.ofSeconds(10L))).build();
    }

    @Override
    public void markUseChat(UUID userUuid) {
        Duration chatDelay = this.chatSettings.chatDelay();
        Player player = this.server.getPlayer(userUuid);
        if (player != null) {
            for (Map.Entry<String, Duration> entry : this.chatSettings.chatCooldowns().entrySet()) {
                Duration duration;
                if (!player.hasPermission(entry.getKey()) || (duration = entry.getValue()).compareTo(chatDelay) >= 0) continue;
                chatDelay = duration;
            }
        }
        this.slowdown.put((Object)userUuid, (Object)Instant.now().plus(chatDelay));
    }

    @Override
    public boolean hasSlowedChat(UUID userUuid) {
        return Instant.now().isBefore(this.slowdown.asMap().getOrDefault(userUuid, Instant.MIN));
    }

    @Override
    public Duration getRemainingSlowDown(UUID userUuid) {
        Instant unlockMoment = (Instant)this.slowdown.asMap().get(userUuid);
        if (unlockMoment == null) {
            return Duration.ZERO;
        }
        return Duration.between(Instant.now(), unlockMoment);
    }
}

