/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.butcher;

import com.eternalcode.core.feature.butcher.ButcherSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.com.eternalcode.multification.notice.NoticeBroadcast;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.litecommand.argument.AbstractViewerArgument;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import com.eternalcode.core.viewer.Viewer;
import com.eternalcode.core.viewer.ViewerService;
import java.util.stream.IntStream;
import org.bukkit.command.CommandSender;

@LiteArgument(type=int.class, name="chunks")
class ButcherArgument
extends AbstractViewerArgument<Integer> {
    static final String KEY = "chunks";
    private final ButcherSettings butcherSettings;
    private final NoticeService noticeService;
    private final ViewerService viewerService;

    @Inject
    ButcherArgument(TranslationManager translationManager, ButcherSettings butcherSettings, NoticeService noticeService, ViewerService viewerService) {
        super(translationManager);
        this.butcherSettings = butcherSettings;
        this.noticeService = noticeService;
        this.viewerService = viewerService;
    }

    @Override
    public ParseResult<Integer> parse(Invocation<CommandSender> invocation, String argument, Translation translation) {
        Viewer viewer = this.viewerService.any(invocation.sender());
        try {
            int value = Integer.parseInt(argument);
            int safeChunkNumber = this.butcherSettings.safeChunkNumber();
            if (value <= 0) {
                return ParseResult.failure((Object)translation.butcher().invalidChunkNumber());
            }
            if (value > safeChunkNumber) {
                NoticeBroadcast placeholder = ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translate -> translate.butcher().safeChunksLimitExceeded())).viewer(viewer)).placeholder("{SAFE_CHUNKS}", String.valueOf(safeChunkNumber));
                return ParseResult.failure((Object)placeholder);
            }
            return ParseResult.success((Object)value);
        }
        catch (NumberFormatException exception) {
            return ParseResult.failure((Object)translation.butcher().invalidChunkNumber());
        }
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<Integer> argument, SuggestionContext context) {
        int safeChunkNumber = this.butcherSettings.safeChunkNumber();
        int range = safeChunkNumber / 5 + 1;
        return (SuggestionResult)IntStream.range(1, range).map(i -> Math.min(i * 5, safeChunkNumber)).mapToObj(String::valueOf).collect(SuggestionResult.collector());
    }
}

