/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.loader.dependency;

import com.eternalcode.core.loader.classloader.IsolatedClassLoader;
import com.eternalcode.core.loader.classloader.IsolatedClassLoaderImpl;
import com.eternalcode.core.loader.dependency.Dependency;
import com.eternalcode.core.loader.dependency.DependencyCollector;
import com.eternalcode.core.loader.dependency.DependencyDownloader;
import com.eternalcode.core.loader.dependency.DependencyException;
import com.eternalcode.core.loader.dependency.DependencyLoadEntry;
import com.eternalcode.core.loader.dependency.DependencyLoadResult;
import com.eternalcode.core.loader.dependency.DependencyLoader;
import com.eternalcode.core.loader.pom.DependencyScanner;
import com.eternalcode.core.loader.pom.PomXmlScanner;
import com.eternalcode.core.loader.relocation.Relocation;
import com.eternalcode.core.loader.relocation.RelocationCacheResolver;
import com.eternalcode.core.loader.relocation.RelocationHandler;
import com.eternalcode.core.loader.repository.LocalRepository;
import com.eternalcode.core.loader.repository.Repository;
import com.google.common.base.Stopwatch;
import com.spotify.futures.CompletableFutures;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Logger;

public class DependencyLoaderImpl
implements DependencyLoader {
    private static final String LOCAL_REPOSITORY_PATH = "libs";
    private final Logger logger;
    private final ExecutorService executor;
    private final DependencyDownloader dependencyDownloader;
    private final RelocationHandler relocationHandler;
    private final DependencyScanner dependencyScanner;
    private final LocalRepository localRepository;
    private final Map<Dependency, Path> loaded = new HashMap<Dependency, Path>();

    public DependencyLoaderImpl(Logger logger, File dataFolder, List<Repository> repositories) {
        this.logger = logger;
        this.localRepository = new LocalRepository(DependencyLoaderImpl.setupCacheDirectory(dataFolder));
        ArrayList<Repository> allRepositories = new ArrayList<Repository>();
        allRepositories.add(this.localRepository);
        allRepositories.addAll(repositories);
        this.executor = Executors.newFixedThreadPool(allRepositories.size() * 5);
        this.dependencyScanner = new PomXmlScanner(allRepositories, this.localRepository);
        this.dependencyDownloader = new DependencyDownloader(logger, this.localRepository, allRepositories);
        this.relocationHandler = RelocationHandler.create(this, new RelocationCacheResolver(this.localRepository));
    }

    @Override
    public DependencyLoadResult load(List<Dependency> dependencies, List<Relocation> relocations) {
        return this.load(new IsolatedClassLoaderImpl(new URL[0]), dependencies, relocations);
    }

    @Override
    public DependencyLoadResult load(IsolatedClassLoader loader, List<Dependency> dependencies, List<Relocation> relocations) {
        DependencyCollector resolved = this.resolveDependencies(dependencies);
        List<DependencyLoadEntry> downloaded = this.downloadDependencies(relocations, resolved);
        return this.loadDependencies(loader, downloaded);
    }

    private DependencyCollector resolveDependencies(List<Dependency> dependencies) {
        DependencyCollector collector = new DependencyCollector();
        this.logger.info("Resolving dependencies...");
        this.runParallel(dependencies, dependency -> this.dependencyScanner.findAllChildren(collector, (Dependency)dependency));
        collector.addScannedDependencies(dependencies);
        this.logger.info("Resolved " + collector.getScannedDependencies().size() + " dependencies");
        return collector;
    }

    private List<DependencyLoadEntry> downloadDependencies(List<Relocation> relocations, DependencyCollector collector) {
        return this.runParallel(collector.getScannedDependencies(), dependency -> {
            Path loaded = this.loaded.get(dependency);
            if (loaded != null) {
                return new DependencyLoadEntry((Dependency)dependency, loaded);
            }
            Path downloadedDependencyPath = this.dependencyDownloader.downloadDependency((Dependency)dependency);
            if (this.relocationHandler == null) {
                return new DependencyLoadEntry((Dependency)dependency, downloadedDependencyPath);
            }
            Path relocatedDependency = this.relocationHandler.relocateDependency(this.localRepository, downloadedDependencyPath, (Dependency)dependency, relocations);
            return new DependencyLoadEntry((Dependency)dependency, relocatedDependency);
        });
    }

    private DependencyLoadResult loadDependencies(IsolatedClassLoader loader, List<DependencyLoadEntry> downloaded) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (DependencyLoadEntry dependencyLoadEntry : downloaded) {
            loader.addPath(dependencyLoadEntry.path());
            this.loaded.put(dependencyLoadEntry.dependency(), dependencyLoadEntry.path());
        }
        stopwatch.stop();
        this.logger.info("Loaded " + downloaded.size() + " dependencies in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms");
        return new DependencyLoadResult(loader, downloaded);
    }

    private <E, R> List<R> runParallel(Collection<E> list, Function<E, R> function) {
        List<CompletableFuture> futures = list.stream().map(dependency -> CompletableFuture.supplyAsync(() -> function.apply(dependency), this.executor)).toList();
        return CompletableFutures.allAsList(futures).orTimeout(60L, TimeUnit.MINUTES).join();
    }

    @Override
    public void close() {
        try {
            this.executor.shutdown();
            this.relocationHandler.close();
        }
        catch (Exception exception) {
            throw new DependencyException("Failed to close relocation handler", exception);
        }
    }

    private static Path setupCacheDirectory(File dataFolder) {
        Path cacheDirectory = dataFolder.toPath().resolve(LOCAL_REPOSITORY_PATH);
        try {
            Files.createDirectories(cacheDirectory, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException ioException) {
            throw new DependencyException("Unable to create libs directory", ioException);
        }
        return cacheDirectory;
    }
}

