/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.loader.classloader;

import com.eternalcode.core.loader.classloader.IsolatedClassLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Objects;

public class IsolatedClassLoaderImpl
extends URLClassLoader
implements IsolatedClassLoader {
    public IsolatedClassLoaderImpl(URL ... urls) {
        super(Objects.requireNonNull(urls, "urls"), ClassLoader.getSystemClassLoader().getParent());
    }

    public IsolatedClassLoaderImpl(ClassLoader parent, URL ... urls) {
        super(Objects.requireNonNull(urls, "urls"), parent);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public void addPath(Path path) {
        try {
            this.addURL(Objects.requireNonNull(path, "path").toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

