/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.loader;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.plugin.Plugin;

class EternalCoreWrapper {
    private static final String LOADER_CORE_CLASS = "com.eternalcode.core.EternalCore";
    private final Class<?> eternalCoreClass;
    private Object eternalCore;

    EternalCoreWrapper(Class<?> eternalCoreClass) {
        this.eternalCoreClass = eternalCoreClass;
    }

    public void enable(Plugin plugin) {
        try {
            Constructor<?> eternalCoreConstructor = this.eternalCoreClass.getConstructor(Plugin.class);
            eternalCoreConstructor.setAccessible(true);
            this.eternalCore = eternalCoreConstructor.newInstance(plugin);
        }
        catch (InvocationTargetException exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            throw new RuntimeException("Can not enable EternalCore: ", exception.getCause());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void disable() {
        try {
            Method disableMethod = this.eternalCoreClass.getMethod("disable", new Class[0]);
            disableMethod.setAccessible(true);
            if (this.eternalCore != null) {
                disableMethod.invoke(this.eternalCore, new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static EternalCoreWrapper create(ClassLoader loader) {
        try {
            Class<?> eternalCoreClass = Class.forName(LOADER_CORE_CLASS, true, loader);
            return new EternalCoreWrapper(eternalCoreClass);
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }
}

